package gov.va.med.mhv.admin.service.vastaff;

import java.util.List;

import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleHistoryDTO;
import gov.va.med.mhv.admin.dto.EmployeeSearchResult;
import gov.va.med.mhv.admin.dto.OrgDTO;
import gov.va.med.mhv.admin.dto.OrgTypeRoleDTO;
import gov.va.med.mhv.admin.dto.RoleDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

public interface EmployeeRoleManagementService {

	
	public RoleDTO getRoleByName(String userName) throws MHVException;
	
	/**
	 * Execute the getOrganizationsOfTypeWhereEmployeeHasRole operation
	 *	This returns organizations of a specific type for an employee if they have an active
	 *	role assignment.
	 *	For instance, this query could pull orgs of type "facility" where user has active "ROI Admin"
	 *	role.  This will be useful for numerous other components, but not used by MUR itself.
	 * @param userName
	 */
	
	
	public List<OrgDTO> getOrganizationsOfTypeWhereEmployeeHasRole(Long empId, String orgType, String roleName) throws MHVException;
	
	
	public List<EmployeeOrgRoleDTO> getEmployeeOrganizationRolesEmployeeCanManage(Long employeeId) throws MHVException;
	
	
	public List<OrgTypeRoleDTO> getRolesAtOrganizationEmployeeCanManage(Long employeeId, Long organizationId) throws MHVException;
	
	
	public List<OrgDTO> getOrganizationsEmployeeCanManage(Long employeeId) throws MHVException;
	
	
	public EmployeeOrgRoleDTO findByEmpOrgRoleId(Long employeeOrgRoleId) throws MHVException;
	
	
	
	public List<EmployeeOrgRoleHistoryDTO> getRoleHistoriesForEmployee(Long employeeId) throws MHVException;
	
	
	public List<EmployeeOrgRoleDTO> getEmployeeOrgRolesAssignedToEmployeeByName(String userName) throws MHVException;
	
	
	public List<EmployeeOrgRoleDTO> getEmployeeOrgRolesAssignedToEmployee(Long employeeId) throws MHVException;
	
	
	public List<EmployeeSearchResult> getEmployeeByUserName(String userName) throws MHVException;
	
	
	public EmployeeOrgRoleDTO updateEmployeeOrganizationRole(Long employeeId, EmployeeOrgRoleDTO employeeOrgRole) throws MHVException;
	
	
	public EmployeeOrgRoleDTO assignEmployeeOrganizationRole(Long requestingEmployeeId, String userName, Long orgId, Long roleId) throws MHVException;
	
}


